<?php

namespace App\Models\GestionTransaction;

use Illuminate\Database\Eloquent\Model;

class Compte extends Model 
{

    protected $table = 'comptes';
    public $timestamps = true;
    protected $fillable = array('partenaire_id', 'operateur_id', 'guichet_id', 'libelle', 'num_compte', 'type_compte');

    public function guichet()
    {
        return $this->belongsTo('App\Models\GestionSiteBusiness\Guichet');
    }

    public function operateur()
    {
        return $this->belongsTo('App\Models\GestionSiteBusiness\Operateur');
    }

    public function transactions()
    {
        return $this->hasMany('App\Models\GestionTransaction\Transaction', 'compte_id');
    }

    public function partenaire()
    {
        return $this->belongsTo('App\Models\GestionPartenaire\Partenaire');
    }

}